const { exec } = require('child_process');
const { promisify } = require('util');
const schedule = require('node-schedule');
const axios = require('axios');
const execAsync = promisify(exec);

const DB_USER = 'root'; // Your MySQL username
const DB_PASSWORD = '%LV^&pbzjsmQ&Cjxuwt)5yZSpr)@zbux'; // Your MySQL password
const DISCORD_WEBHOOK_URL = 'https://discord.com/api/webhooks/1410395647148032080/CnUYieq2BleoeNO_tKM2S6wW7rpERQReDCJkDA-jUPCTDXE-GGmrC6wgphwZ2pTJwOgt'; // Your Discord webhook URL
const databases = ['panel', 'ctrlpanel', 'paymenter']; // Add or change databases here if needed

async function getCurrentDateTime() {
    const now = new Date();
    const date = now.toISOString().split('T')[0];
    const time = now.toTimeString().split(' ')[0].replace(/:/g, '-');
    return { date, time };
}

async function backupDatabase(databaseName) {
    const { date, time } = await getCurrentDateTime();
    const backupFile = `/database/${databaseName}/${databaseName}-${date}-${time}.sql`;

    try {
        const { stdout, stderr } = await execAsync(`mysqldump -u ${DB_USER} -p'${DB_PASSWORD}' --opt ${databaseName} > ${backupFile}`);
        // Filter out the deprecated warning message and handle other errors
        if (stderr && !stderr.includes('Deprecated program name')) {
            throw new Error(stderr);
        }
        console.log(`${databaseName} backup completed: ${stdout}`);
        sendDiscordWebhook(`${databaseName} backup completed: ${backupFile}`);
    } catch (error) {
        console.error(`Error executing ${databaseName} backup: ${error.message}`);
        sendDiscordWebhook(`Error executing ${databaseName} backup: ${error.message}`);
    }
}

async function backupDatabases() {
    for (const db of databases) {
        await backupDatabase(db);
    }
}

function sendDiscordWebhook(message) {
    const embed = {
        embeds: [{
            description: message,
            color: 0x00ff00,
            timestamp: new Date().toISOString(),
        }]
    };

    axios.post(DISCORD_WEBHOOK_URL, embed)
        .then(response => {
            console.log('Discord webhook sent:', response.data);
        })
        .catch(error => {
            console.error('Error sending Discord webhook:', error.message);
        });
}

// Schedule backup every 3 hours, change /3 to the amount you want
schedule.scheduleJob('0 */3 * * *', backupDatabases);

backupDatabases();
